<?php

namespace IZON\Logs\Appenders;

use GuzzleHttp\Psr7\ServerRequest;
use IZON\Logs\DataAppenderInterface;
use Throwable;

class RequestDataAppender implements DataAppenderInterface
{
    protected bool $initialized = false;

    protected ?array $requestData = null;

    public function append(array $context): array
    {
        $data = $this->getRequest();
        $context['contexts']['request'] = $data;
        return $context;
    }

    protected function getRequest(): array
    {
        if ($this->initialized) {
            return $this->requestData;
        }

        try {
            $request = ServerRequest::fromGlobals();
            $this->requestData = [
                'url' => (string)$request->getUri(),
                'method' => $request->getMethod(),
                'query' => $request->getQueryParams(),
                'parsedBody' => $request->getParsedBody(),
                'headers' => $request->getHeaders(),
                'cookies' => $request->getCookieParams(),
            ];
        } catch (Throwable $ex) {
            $this->requestData = ['status' => 'Could not create request.', 'exception' => $ex];
        }
        $this->initialized = true;
        return $this->requestData;
    }
}
