<?php

namespace IZON\Logs;

use Monolog\Logger as MonologLogger;
use Psr\Log\LoggerInterface;
use Psr\Log\LoggerTrait;

/**
 * Description of Logger
 *
 * @author Lukas Linhart
 */
class Logger implements LoggerInterface, LoggerFactoryInterface {

    use LoggerTrait;

    protected MonologLogger $logger;
    /**
     *
     * @var DataAppenderInterface[]
     */
    protected array $appenders = [];

    function __construct(MonologLogger $logger, array $appenders = []) {
        $this->logger = $logger;
        $this->appenders = $appenders;
    }
    /**
     *
     * @param string|null $name
     * @return Logger
     */
    public static function getLogger(?string $name): Logger {
        return LoggerFactory::getLogger($name);
    }
    /**
     *
     * @param string|int $level
     * @param string $message
     * @param array $context
     * @return void
     */
    public function log($level, $message, array $context = []): void {
        $newContext = $this->appendData($context);
        $this->logger->log($level, $message, $newContext);
    }
    /**
     * append data from appenders
     *
     * @param array<string, mixed> $context
     * @return array<string, mixed>
     */
    protected function appendData(array $context) {
        $newContext = $context;
        foreach($this->appenders as $appender) {
            $newContext = $appender->append($newContext);
        }
        return $newContext;
    }

}
