<?php

namespace IZON\Logs\Utils;

use IZON\Logs\Exceptions\UserAgentParseException;
use Throwable;
use WhichBrowser\Parser;

/**
 * user agent parser
 */
class UserAgent {

    protected ?Parser $data = null;
    /**
     *
     * @param null|string $browserString
     * @throws UserAgentParseException
     */
    public function __construct(?string $browserString) {
        try {
            $this->data = new Parser($browserString);
        } catch (Throwable $ex) {
            throw new UserAgentParseException('could not parse browser', $ex->getCode(), $ex);
        }
    }
    /**
     *
     * @return string
     */
    public function getBrowserName() : string {
        $name = $this->data->browser->getName();
        if(empty($name)) {
            $name = '';
        }
        return $name;
    }
    /**
     *
     * @return string
     */
    public function getBrowserVersion() : string {
        $version = $this->data->browser->getVersion();
        if(empty($version)) {
            $version = '';
        }
        return $version;
    }
    /**
     *
     * @return string
     */
    public function getPlatform() : string {
        $os = $this->data->os->toString();
        if(empty($os)) {
            $os = '';
        }
        return $os;
    }

}
