<?php

namespace IZON\Logs\Utils;

use IZON\Logs\Exceptions\UserAgentParseException;
use WhichBrowser\Parser;

/**
 * Description of UserAgent
 *
 * @author lukas
 */
class UserAgent {
    /**
     *
     * @var Parser
     */
    protected $data;
    /**
     * 
     * @param string $browserString
     * @throws UserAgentParseException
     */
    public function __construct(?string $browserString) {
        try {
            $this->data = new Parser($browserString);
        } catch (Throwable $ex) {
            throw new UserAgentParseException('could not parse browser', ['exception' => $ex]);
        }
    }
    /**
     * 
     * @return string
     */
    public function getBrowserName() : string {
        $name = $this->data->browser->name;
        if(empty($name)) {
            $name = '';
        }
        return $name;
    }
    /**
     * 
     * @return string
     */
    public function getBrowserVersion() : string {
        $version = $this->data->browser->getVersion();
        if(empty($version)) {
            $version = '';
        }
        return $version;
    }
    /**
     * 
     * @return string
     */
    public function getPlatform() : string {
        $os = $this->data->os->toString();
        if(empty($os)) {
            $os = '';
        }
        return $os;
    }

}
