<?php

namespace IZON\Logs\Utils;

use IZON\Logs\Exceptions\UserAgentParseException;
use WhichBrowser\Parser;

/**
 * Description of UserAgent
 *
 * @author lukas
 */
class UserAgent {
    /**
     *
     * @var Parser
     */
    protected $data;
    /**
     * 
     * @param string $browserString
     * @throws UserAgentParseException
     */
    public function __construct(?string $browserString) {
        try {
            $this->data = new Parser($browserString);
        } catch (Throwable $ex) {
            throw new UserAgentParseException('could not parse browser', ['exception' => $ex]);
        }
    }
    /**
     * 
     * @return string
     */
    public function getBrowserName() : string {
        return $this->data->browser->name;
    }
    /**
     * 
     * @return string
     */
    public function getBrowserVersion() : string {
        return $this->data->browser->getVersion();
    }
    /**
     * 
     * @return string
     */
    public function getPlatform() : string {
        return $this->data->os->toString();
    }

}
