<?php

namespace IZON\Logs\Appenders;

use IZON\Logs\DataAppenderInterface;
use IZON\Logs\Exceptions\UserAgentParseException;
use IZON\Logs\Utils\UserAgent;

/**
 * add user agent data to log context
 *
 * @author lukas
 */
class UserAgentDataAppender implements DataAppenderInterface {
    /**
     *
     * @var bool
     */
    protected $inited = false;
    /**
     *
     * @var UserAgent|null
     */
    protected $userAgent;
    /**
     * append user agent
     * @param array $context
     * @return array
     */
    public function append(array $context): array {
        if(!empty($this->getUserAgent())) {
            $context['contexts']['browser'] = [
                'name' => $this->getUserAgent()->getBrowserName(),
                'version' => $this->getUserAgent()->getBrowserVersion(),
            ];
            $context['contexts']['os'] = ['name' => $this->getUserAgent()->getPlatform()];
        }
        return $context;
    }
    /**
     * get user agent
     * 
     * @return UserAgent|null
     */
    protected function getUserAgent(): ?UserAgent {
        if(!$this->inited) {
            if(array_key_exists('HTTP_USER_AGENT', $_SERVER)) {
                $agentString = $_SERVER['HTTP_USER_AGENT'];
            }
            
            if(!empty($agentString)) {
                try {
                    $this->userAgent = new UserAgent($agentString);
                } catch (UserAgentParseException $ex) {
                    $this->userAgent = null;
                }
            }
            $this->inited = true;
        }
        return $this->userAgent;
    }

}
