<?php

namespace IZON\Logs\Deduplication\Tests;

use IZON\Logs\Deduplication\DeduplicationHandler;
use IZON\Logs\Deduplication\SQLiteDeduplicationManager;
use IZON\Logs\Logger;
use IZON\Logs\LoggerFactory;
use Monolog\Handler\TestHandler;
use PHPUnit\Framework\TestCase;

class LoggerTest extends TestCase
{
    protected string $dbPath = __DIR__ . '/logs/log-deduplication.sqlite';

    protected TestHandler $testHandler;

    protected DeduplicationHandler $deduplicationHandler;

    protected Logger $logger;

    public function setUp(): void
    {
        if (file_exists($this->dbPath)) {
            unlink($this->dbPath);
        }
        $this->testHandler = new TestHandler();
        $deduplicationManager = new SQLiteDeduplicationManager(
            $this->dbPath,
            60 * 60
        );
        // envelope tu buffer handler to send email in the end of script (aggregate all logged entries to one email)
        $this->deduplicationHandler = new DeduplicationHandler(
            $this->testHandler,
            $deduplicationManager,
            0
        );
        LoggerFactory::configure([
            // HANDLERS
            'handlers' => [
                'deduplication' => $this->deduplicationHandler,
            ],
            'channels' => [
                'default' => ['deduplication'],
            ],
        ]);

        $this->logger = LoggerFactory::getLogger(__CLASS__);
    }

    public function testDeduplicate(): void
    {
        $this->logger->error('test1', ['exception' => new \Exception('test1')]);

        // force handler to process all buffered records
        $this->deduplicationHandler->flush();

        $this->assertTrue($this->testHandler->hasErrorRecords());
        $this->assertTrue($this->testHandler->hasErrorThatContains('test1'));
    }
}
