<?php

namespace IZON\Logs\Deduplication;

use DateTimeImmutable;

interface DeduplicationManagerInterface
{
    /**
     * deduplicate records
     * @param array<int, array{"message": string, "context": array<string, mixed>, "level": int, "level_name": string, "channel": string, "datetime": DateTimeImmutable, "extra": array<string, mixed>}> $records
     * @return array<int, array{"message": string, "context": array<string, mixed>, "level": int, "level_name": string, "channel": string, "datetime": DateTimeImmutable, "extra": array<string, mixed>}>
     *  record example:
     *  {
     *     "message":"test1",
     *     "context":{"exception": new Exception("test1"), ...},
     *     "level":400,
     *     "level_name":"ERROR",
     *     "channel":"IZON\\Logs\\Deduplication\\Tests\\LoggerTest",
     *     "datetime": new DateTimeImmutable(), // record creation time
     *     "extra":[]
     *  }
     * https://github.com/Seldaek/monolog/blob/main/doc/message-structure.md
     */
    public function deduplicate(array $records): array;

    /**
     * dumps old records that are out of aggregation window
     * @return array<int, array{"message": string, "context": array<string, mixed>, "level": int, "level_name": string, "channel": string, "datetime": DateTimeImmutable, "extra": array<string, mixed>}>
     */
    public function popOldRecords(): array;

    /**
     * remove old records from the deduplication manager
     * @return void
     */
    public function gc(): void;
}
