<?php

namespace IZON\Gallery\Web\Interceptors;

use \IZON\Logs\Logger;

use \IZON\MVC\Interceptors\Interceptor;
use \IZON\MVC\HttpRequest;
use \IZON\MVC\ModelAndView;

use \IZON\Gallery\Services\GalleryService;

/**
 * nacita informace o ga
 */
class LoadedGalleryInfoInterceptor implements Interceptor {
    
    /**
     *
     * @var GalleryService 
     */
    protected $galleryService;
    
    /**
     *
     * @var string pod jakym klicem se predava 
     */
    protected $galleryInfoIndentifier = "_galleryInfo";


    /**
     * logger pro tridu
     * @var Logger 
     */
    protected $log;
    
    
    public function __construct(GalleryService $galleryService) {
        $this->galleryService = $galleryService;
        
        // logovani
        $this->log = Logger::getLogger(__CLASS__);
    }
    
    public function afterCompletion(HttpRequest $request, $exception) {
        
    }

    public function preHandle(HttpRequest $request) {
        
    }

    public function postHandle(HttpRequest $request, ModelAndView $model) {
        // adds information about gallery
        $model->putParameter($this->galleryInfoIndentifier, $this->galleryService->getGalleryInfo());
        return $model;
    }

}
