<?php

namespace IZON\Gallery\Web\Controllers;

use Exception;

use IZON\IO\Image;

use \IZON\MVC\Controller;
use \IZON\MVC\HttpRequest;
use \IZON\MVC\ModelAndView;
use IZON\MVC\Exceptions\PageNotFoundException;

use IZON\Gallery\Services\GalleryService;

/**
 *  resizes gallery image and sends redirect to this newly created image
 */
class GalleryImageController implements Controller {

    /**
     * @var GalleryService
     */
    protected $galleryService;

    /**
     * @var string in what directory to search images
     */
    protected $fsRoot;


/// generated constructor
    function __construct(GalleryService $galleryService, $fsRoot) {
        $this->galleryService = $galleryService;
        $this->fsRoot = $fsRoot;
    }

    public function execute(HttpRequest $request) {
        $imageURL = $request->getParameter("imageURL");
        $resizeParameters = [];
        if( $request->hasParameter("resizeParameters") ) {
            $resizeParameters = $request->getParameter("resizeParameters");
        }

        if( !is_array($resizeParameters) ) {
            http_response_code(400);
            echo 'invalid resize parameters provided';
            die();
        }

        $imageParh = $this->fsRoot . $imageURL;
        if(
            file_exists($imageParh)
            && is_file($imageParh)
        ) {

            $image = new Image($imageParh);
            $resizedImagePath = $this->galleryService->resizeImage($image, $resizeParameters);

            return ModelAndView::createURLRedirect($resizedImagePath);
        } else {
            throw new PageNotFoundException();
        }
    }

}
