<?php
/**
 * funkce pro automaticke resizovani obrazku
 */
namespace PHPView\IZON\Gallery;

use Exception;

use IZON\IO\Image;
use IZON\Gallery\GalleryInfo;

/**
 * vezme obrazek a vrati odkaz do galerie s resizovanym obrazkem
 * @param Image $mage
 * @param array parametry pro resizovani width = cislo, heigth = cislo nebo type type = ["contain": vleze se do, "cover": da se pokryt] default je contain napr. ["width" => 1234], ["width" => 1234, "type" => "contain"]
 * @return string url
 */
function getGalleryImageURL(Image $image, $params = []) {
    /* @var $gallery GalleryInfo */
    $gallery = \PHPView\getParameter("_galleryInfo");
    if($gallery === NULL) {
        throw new Exception("_galleryInfo is not present in view");
    }
    return $gallery->getImageURL($image, $params);
}