<?php

namespace IZON\Gallery\Services\Impl;

use \Exception;

use \IZON\IO\Image;

use \IZON\Gallery\ImageResizer;

use \IZON\Gallery\Services\GalleryService;
use \IZON\Gallery\GalleryInfo;

/**
 * servis pro zpracovani obrazku, mozna i dalsiho multimedialniho obsahu z galerie
 */
class GalleryServiceImpl implements GalleryService {

    /**
     *
     * @var string do jakeho adresare se ma galerie ukladat
     */
    protected $galleryDir;

    /**
     * @var array z jakych adresaru je mozne galerii brat
     */
    protected $sourceDirs;

    /**
     * @var array<string, string> na jakem url se da zobrazit
     */
    protected $galleryURLs;

    /**
     * @var integer id of last used galery
     */
    protected $lastUserGaleryURLIndex = 0;

    /**
     * @var string pattern for URL to call gallery controller
     */
    protected $resizeControllerOutputURLPattern;


    public function __construct(
        $galleryDir,
        array $sourceDirs,
        $galleryURLs
    ) {
        $this->galleryDir = $galleryDir;
        $this->sourceDirs = $sourceDirs;
        $this->galleryURLs = $galleryURLs;
    }

    /**
     * vrati informace o thumbnailech ze kterych je mozno zjistit
     * @var GalleryInfo
     */
    public function getGalleryInfo() {
        return new GalleryInfo($this);
    }

    /**
     *
     * @param Image $sourceImage
     * @param array $parameters parametry pro resizovani
     */
    public function getImageURL(Image $sourceImage, array $parameters = []) {
        // test jestli je z podporovanych adresaru
        $fileDir = \IZON\File\normalizeFileName($sourceImage->getDir());
        foreach($this->sourceDirs as $destDir => $srcDir) {
            $srcDir = \IZON\File\normalizeFileName($srcDir);
            if( \IZON\File\isInSubDir($fileDir, $srcDir) ) {
                $subDir = str_replace($srcDir, '', $fileDir); // nemenit jinak korektne nefunguje pokud je soubot primo v $srcDir
                if( $destDir != '' ) {
                    $destinationDir = $this->galleryDir ."/". $destDir;
                } else {
                    $destinationDir = $this->galleryDir;
                }
                break;
            }
        }
        if( !isset($destinationDir) ) {
            throw new Exception("Pristupuje do nepovoleného adresare ". $sourceImage->getDir());
        }

        if( !isset($parameters['width'])
            || !is_numeric($parameters['width']) ) {
            $parameters['width'] = 0;
        }
        if( !isset($parameters['height'])
            || !is_numeric($parameters['height']) ) {
            $parameters['height'] = 0;
        }

        $original_size = getimagesize($sourceImage->getFsPath());

        $thumb['w'] = 0;
        $thumb['h'] = 0;
        if( isset($parameters["type"])
            && $parameters["type"] == "cover" ) {
            list($thumb['w'], $thumb['h']) = ImageResizer::getNewCoverImageSize(array($original_size[0], $original_size[1]),
                                                                            array($parameters['width'], $parameters['height']));
        } else {
            list($thumb['w'], $thumb['h']) = ImageResizer::getNewImageSize(array($original_size[0], $original_size[1]),
                                                                        array($parameters['width'], $parameters['height']));
        }



        $pathParts = pathinfo($sourceImage->getFsPath());
        $thumbName = $pathParts['filename'] ."_". $thumb['w']. 'x' . $thumb['h'] .".". $sourceImage->getExtension();

        $resizerParams['sourceFile']          = $sourceImage->getFileName();
        $resizerParams['sourceDir']           = $fileDir .'/';
        $resizerParams['newSize']             = array($thumb['w'], $thumb['h']);
        $resizerParams['targetDir']           = $destinationDir . $subDir .'/';
        $resizerParams['targetFile']          = $thumbName;
        $resizerParams['params']['quality']   = 85;

        try {
            $tFile = $resizerParams['targetDir'] . $thumbName;
            if( file_exists($tFile) ) {
                // pokud jiz nahled v pozadovane velikosti existuje
                if( filemtime($sourceImage->getFsPath()) > filemtime($tFile) ) {
                    if( $this->resizeControllerOutputURLPattern !== NULL ) {
                        return $this->resizeControllerOutputURLPattern . "/". $destDir . $subDir ."/". $sourceImage->getFileName() . $this->serializeParametersArrayToURL($parameters);
                    } else {
                        // je nahled starsi, nez zdrojovy obrazek - vygenerujem novy nahled
                        ImageResizer::resizerParams($resizerParams);
                    }
                }
            } else {
                if( $this->resizeControllerOutputURLPattern !== NULL ) {
                    return $this->resizeControllerOutputURLPattern . "/". $destDir . $subDir ."/". $sourceImage->getFileName() . $this->serializeParametersArrayToURL($parameters);
                } else {
                    // je nahled starsi, nez zdrojovy obrazek - vygenerujem novy nahled
                    ImageResizer::resizerParams($resizerParams);
                }
            }
        } catch (Exception $exc) {
            throw $exc;
        }

        $galleryIndex = $this->lastUserGaleryURLIndex + 1;
        $galleryIndex = $galleryIndex % count($this->galleryURLs);
        $this->lastUserGaleryURLIndex = $galleryIndex;

        $url = $this->galleryURLs[$galleryIndex];
        if( $destDir != '' ) {
            $url .= "/". $destDir;
        }
        $url .= $subDir ."/". $thumbName ."?ts=". filemtime($tFile);
        return $url;
    }


    public function getImageParams(Image $sourceImage, array $parameters = []) {
        // test jestli je z podporovanych adresaru
        $fileDir = \IZON\File\normalizeFileName($sourceImage->getDir());
        foreach($this->sourceDirs as $destDir => $srcDir) {
            $srcDir = \IZON\File\normalizeFileName($srcDir);
            if( \IZON\File\isInSubDir($fileDir, $srcDir) ) {
                $subDir = str_replace($srcDir, '', $fileDir); // nemenit jinak korektne nefunguje pokud je doubot primo v $srcDir
                if( $destDir != '') {
                    $destinationDir = $this->galleryDir ."/". $destDir;
                } else {
                    $destinationDir = $this->galleryDir;
                }
            }
        }
        if( !isset($destinationDir) ) {
            throw new Exception("Pristupuje do nepovoleného adresare ". $sourceImage->getDir());
        }

        if( !isset($parameters['width'])
            || !is_numeric($parameters['width']) ) {
            $parameters['width'] = 0;
        }
        if( !isset($parameters['height'])
            || !is_numeric($parameters['height']) ) {
            $parameters['height'] = 0;
        }

        $original_size = getimagesize($sourceImage->getFsPath());

        $thumb['w'] = 0;
        $thumb['h'] = 0;
        if( isset($parameters["type"])
            && $parameters["type"] == "cover" ) {
            list($thumb['w'], $thumb['h']) = ImageResizer::getNewCoverImageSize(
                array($original_size[0], $original_size[1]),
                array($parameters['width'], $parameters['height'])
            );
        } else {
            list($thumb['w'], $thumb['h']) = ImageResizer::getNewImageSize(
                array($original_size[0], $original_size[1]),
                array($parameters['width'], $parameters['height'])
            );
        }

        $pathParts = pathinfo($sourceImage->getFsPath());
        $thumbName = $pathParts['filename'] . "_" . $thumb['w'] . 'x' . $thumb['h'] . "." . $sourceImage->getExtension();



        $resizerParams['sourceFile'] = $sourceImage->getFileName();
        $resizerParams['sourceDir'] = $fileDir . '/';
        $resizerParams['newSize'] = array($thumb['w'], $thumb['h']);
        $resizerParams['targetDir'] = $destinationDir . $subDir . '/';
        $resizerParams['targetFile'] = $thumbName;
        $resizerParams['params']['quality'] = 85;

        try {
            if (file_exists($resizerParams['targetDir'] . $thumbName)) {
                // pokud jiz nahled v pozadovane velikosti existuje
                if (filemtime($sourceImage->getFsPath()) > filemtime($resizerParams['targetDir'] . $thumbName)) {
                    // je nahled starsi, nez zdrojovy obrazek - vygenerujem novy nahled
                    ImageResizer::resizerParams($resizerParams);
                }
            } else {
                // nahled neni, vygenerujem jej
                ImageResizer::resizerParams($resizerParams);
            }
        } catch (Exception $exc) {
            throw $exc;
        }

        $galleryIndex = $this->lastUserGaleryURLIndex + 1;
        $galleryIndex = $galleryIndex % count($this->galleryURLs);
        $this->lastUserGaleryURLIndex = $galleryIndex;
        return [
            "imgURL" => $sourceImage->getWebURI(),
            "width" => $original_size[0],
            "height" => $original_size[1],
            "resizedImgURL" => $this->galleryURLs[$galleryIndex] . "/" . $destDir . $subDir . "/" . $thumbName,
            "resizedWidth" => $thumb['w'],
            "resizedHeight" => $thumb['h']
        ];
    }

    public function resizeImage(Image $sourceImage, array $parameters) {
        // test jestli je z podporovanych adresaru
        $fileDir = \IZON\File\normalizeFileName($sourceImage->getDir());
        foreach($this->sourceDirs as $destDir => $srcDir) {
            $srcDir = \IZON\File\normalizeFileName($srcDir);
            if( \IZON\File\isInSubDir($fileDir, $srcDir) ) {
                $subDir = str_replace($srcDir, '', $fileDir); // nemenit jinak korektne nefunguje pokud je doubot primo v $srcDir
                if( $destDir != '') {
                    $destinationDir = $this->galleryDir ."/". $destDir;
                } else {
                    $destinationDir = $this->galleryDir;
                }
            }
        }
        if( !isset($destinationDir) ) {
            throw new Exception("Pristupuje do nepovoleného adresare ". $sourceImage->getDir());
        }

        if( !isset($parameters['width'])
            || !is_numeric($parameters['width']) ) {
            $parameters['width'] = 0;
        }
        if( !isset($parameters['height'])
            || !is_numeric($parameters['height']) ) {
            $parameters['height'] = 0;
        }

        $original_size = getimagesize($sourceImage->getFsPath());

        $thumb['w'] = 0;
        $thumb['h'] = 0;
        if( isset($parameters["type"])
            && $parameters["type"] == "cover" ) {
            list($thumb['w'], $thumb['h']) = ImageResizer::getNewCoverImageSize(array($original_size[0], $original_size[1]),
                                                                            array($parameters['width'], $parameters['height']));
        } else {
            list($thumb['w'], $thumb['h']) = ImageResizer::getNewImageSize(array($original_size[0], $original_size[1]),
                                                                        array($parameters['width'], $parameters['height']));
        }

        $pathParts = pathinfo($sourceImage->getFsPath());
        $thumbName = $pathParts['filename'] ."_". $thumb['w']. 'x' . $thumb['h'] .".". $sourceImage->getExtension();

        $resizerParams['sourceFile']          = $sourceImage->getFileName();
        $resizerParams['sourceDir']           = $fileDir .'/';
        $resizerParams['newSize']             = array($thumb['w'], $thumb['h']);
        $resizerParams['targetDir']           = $destinationDir . $subDir .'/';
        $resizerParams['targetFile']          = $thumbName;
        $resizerParams['params']['quality']   = 85;

        try {
          if (file_exists($resizerParams['targetDir'] . $thumbName)) {
            // pokud jiz nahled v pozadovane velikosti existuje
            if (filemtime($sourceImage->getFsPath()) > filemtime($resizerParams['targetDir'] . $thumbName)) {
              // je nahled starsi, nez zdrojovy obrazek - vygenerujem novy nahled
              ImageResizer::resizerParams($resizerParams);
            }
          } else {
            // nahled neni, vygenerujem jej
            ImageResizer::resizerParams($resizerParams);
          }
        } catch (Exception $exc) {
          throw $exc;
        }

//        return new Image($destinationDir . $subDir .'/'. $thumbName);

        $galleryIndex = $this->lastUserGaleryURLIndex + 1;
        $galleryIndex = $galleryIndex % count($this->galleryURLs);
        $this->lastUserGaleryURLIndex = $galleryIndex;

        $url = $this->galleryURLs[$galleryIndex];
        if( $destDir != '' ) {
            $url .= "/". $destDir;
        }
        $url .= $subDir ."/". $thumbName;
        return $url;
    }

    function setResizeControllerOutputURLPattern($resizeControllerOutputURLPattern) {
        $this->resizeControllerOutputURLPattern = $resizeControllerOutputURLPattern;
    }

    protected function serializeParametersArrayToURL(array $paramaters) {
        $paramsParts = [];
        foreach($paramaters as $key => $value) {
            $paramsParts[] = "resizeParameters[". $key ."]=". $value;
        }
        return (\IZON\Arrays\isEmpty($paramsParts) ? "" : "?") . implode("&amp;", $paramsParts);
    }
}
