<?php

namespace IZON\Gallery\Services;

use IZON\IO\Image;

/**
 * servis pro vytvareni nahledu
 */
interface GalleryService {
    
    /**
     * vrati informace o thumbnailech ze kterych je mozno zjistit 
     * @var GalleryInfo
     */
    public function getGalleryInfo();
    
    /**
     * 
     * @param Image|string $sourceImage
     * @param array $parameters parametry pro resizovani width nebo heigth
     * @return string 
     * 
     */
    public function getImageURL(Image $sourceImage, array $parameters = []);
    
    /**
     * 
     * @param Image|string $sourceImage
     * @param array $parameters parametry pro resizovani width nebo heigth
     * @return arra
     */
    public function getImageParams(Image $sourceImage, array $parameters = []);
}
