<?php

namespace IZON\Gallery\MVC\Routers;

use function \IZON\String\startsWith;

use IZON\Utils\Locale;

use \IZON\Logs\Logger;

use IZON\MVC\HttpRequest;
use IZON\MVC\Routers\RouteInfo;
use IZON\MVC\Routers\RouteDefinition;

use IZON\Gallery\Services\GalleryService;

/**
 * Definice routovani nacitana z db
 */
class GalleryRouteDefinition implements RouteDefinition {
    
    /**
     * @var GalleryService
     */
    protected $galleryService;

    /**
     * @var string url to call image controller
     */
    protected $resizeControllerURLPattern = '/_gallery';

    /**
     * @var string url pattern for calling image controller
     */
    protected $resizeControllerOutputURLPattern = '/_gallery';
    
    /**
     * @var string id of controller to call 
     */
    protected $galleryImageControllerId;

    /**
     * @var Logger 
     */
    protected $log = NULL;
    
    
    function __construct(GalleryService $galleryService, $galleryImageControllerId) {
        $this->galleryService = $galleryService;
        $this->galleryImageControllerId = $galleryImageControllerId;
        
        $this->galleryService->setResizeControllerOutputURLPattern($this->resizeControllerOutputURLPattern);
        
        $this->log = Logger::getLogger(self::class);
    }
    
    
    public function findRoute(HttpRequest $request) {
        $url = $request->getURL();
        if( startsWith($url, $this->resizeControllerURLPattern) ) {
            $parameters = $request->getParameters();
            
            $imageURL = mb_substr($url, mb_strlen($this->resizeControllerURLPattern));
            $request->addParameter("imageURL", $imageURL);
            $parameters["imageURL"] = $imageURL;
            
            $routeInfo = new RouteInfo();
            $routeInfo->setUrl($request->getUrl());
            $routeInfo->setContrlollerId($this->galleryImageControllerId);
            $routeInfo->setParameters($parameters);
            return $routeInfo;
        }
        return NULL;
    }

    public function findURL($controllerId, array $parameters, $methodName, Locale $locale) {
        $this->log->info("searching for url for controllerId = $controllerId with ". count($parameters) ." parameters");
    }
    
    public function setURLPatterns($resizeControllerURLPattern, $resizeControllerOutputURLPattern) {
        $this->resizeControllerURLPattern  = $resizeControllerURLPattern;
        $this->resizeControllerOutputURLPattern = $resizeControllerOutputURLPattern;
        
        $this->galleryService->setResizeControllerURLPattern($this->resizeControllerOutputURLPattern);
    }
}
