<?php

namespace IZON\Gallery;

use IZON\Gallery\Services\GalleryService;

use IZON\IO\Image;

/**
 * Slouzi k ziskani informaci o galerii a obrazcich, ktere jsou v ni spravovany
 */
class GalleryInfo {
   
    /**
     * @var GalleryService
     */
    protected $galeryService;
    
    
    function __construct($galeryService) {
        $this->galeryService = $galeryService;
    }

    /**
     * vraci url na ktrem se da stahnout resizovany obrazek
     * @param Image $sourceImage zdrojovy obrazek
     * @param array parametry pro resizovani width = cislo, heigth = cislo nebo type type = ["contain": vleze se do, "cover": da se pokryt] default je contain napr. ["width" => 1234], ["width" => 1234, "type" => "contain"]
     * @return string
     */
    public function getImageURL(Image $sourceImage, array $parameters = []) {
        return $this->galeryService->getImageURL($sourceImage, $parameters);
    }
    
    /**
     * vraci url na ktrem se da stahnout resizovany obrazek
     * @param Image $sourceImage zdrojovy obrazek
     * @param array parametry pro resizovani width = cislo, heigth = cislo nebo type type = ["contain": vleze se do, "cover": da se pokryt] default je contain napr. ["width" => 1234], ["width" => 1234, "type" => "contain"]
     * @return array
     */
    public function getImageParams(Image $sourceImage, array $parameters = []) {
        return $this->galeryService->getImageParams($sourceImage, $parameters);
    }
}
