<?php

namespace IZON\Forms\Fields;

use IZON\Utils\Email;
use IZON\Forms\Fields\BaseField;
use IZON\Forms\ValidationRule;

/**
 * Emailove pole
 */
class MultipleEmailField extends CharField {

    public function __construct($name, $label = '', $params = array()) {
        $ret = parent::__construct($name, $label, $params);

        $function = function(BaseField $field, $args = array()) {
            // prazdne pole se neestuje
            if ($field->parse() == '') {
                return true;
            }
            $parsed = $field->parse();
            $emails = preg_split('/\s*,\s*/', $parsed);
            $i = 1;
            foreach ($emails as $email) {
                if (empty($email)) {
                    $field->addError(sprintf(_('Není vyplněný %s. email.'), $i));
                }
                if(!Email::isEmail($email)) {
                    $field->addError(sprintf(_('Email %s. není validní.'), $i));
                }
                $i++;
            }
            return !$field->hasErrors();
        };
        $rule = new ValidationRule($function, _('Zadané emaily nejsou platné.'));
        $this->addRule($rule);

        return $this;
    }

    protected function getSpecificSupportedProperties(): array {
        return [];
    }
}
