<?php

namespace IZON\Forms\Fields;

use Exception;
use IZON\Forms\ValidationRule;

/**
 * Pole odpovidajici rozsahu cisel ve kterem se da posunovat
 * https://www.w3.org/wiki/HTML/Elements/input/range
 */
class IntegerRangeField extends BaseField {
    
    /**
     * @var int minimalni hodnota, ktera muze byt do pole zadana
     */
    protected $minValue = FALSE;
    
    /**
     * @var int maximalni hodnota, ktera muze byt do pole zadana
     */
    protected $maxValue = FALSE;
    
    /**
     * @var int
     */
    protected $step = 1;

    /**
     * @var array pole s moznymi hodnotami soupatoru 
     */
    protected $valuesList = NULL;

    /**
     * IntegerRangeField constructor.
     * @param $name
     * @param int $minValue
     * @param int $maxValue
     * @param string $label
     * @param array $params
     * @throws Exception
     */
    public function __construct($name, int $minValue, int $maxValue, $label = '', $params = array()) {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
        $this->errors = array();
        
        if( $maxValue < $minValue ) {
            throw new Exception("minValue = ". $minValue ." nesmi byt vetsi nez maxValue = ". $maxValue);
        }
        
        $this->minValue = $minValue;
        $this->maxValue = $maxValue;
        
        $rule = new ValidationRule();
        $rule->setMessage(_('Zadaná hodnota je mimo rozsah.'));

        $function = function(IntegerRangeField $field, $args = array()) {
            return $field->getMinValue() <= $field->getValue() // je mensi nez minimum
                    && $field->getValue() <= $field->getMaxValue(); // je vetsi nez maximum
        };
        $rule->setValidator($function);
        $this->addRule($rule);
        
        return $this;
    }
    
    public function parse() {
        return $this->value;
    }

    public function serialize($value) {
        $this->value = $value;
    }

    function getMinValue(): int {
        return $this->minValue;
    }

    function setMinValue(int $minValue) {
        $this->minValue = $minValue;
    }

    function getMaxValue(): int {
        return $this->maxValue;
    }

    function setMaxValue(int $maxPrice) {
        $this->maxValue = $maxPrice;
    }
    
    public function getStep(): int {
      return $this->step;
    }

    public function setStep(int $step) {
        if( $step <= 0) {
            throw new Exception("Step nesmi byt nulovy nebo zaporny");
        }
        $this->step = $step;
    }

    protected function getSpecificSupportedProperties(): array {
        return [];
    }
}
