<?php

namespace IZON\Forms;

use IZON\Forms\Fields\BaseField;

/**
 * Validacni pravidlo
 */
class ValidationRule
{
    /**
     *
     * @var BaseField ke kteremu poli se validacni pravidlo vaze
     */
    public BaseField $field;

    /**
     * @var callable funkce provadejici validaci
     */
    public $validator;

    public ?string $message = null;

    /**
     * argumenty potrebne pro validaci pravidla
     * @var array
     */
    public array $args;


    public function __construct(?callable $validator = null, ?string $message = null, $args = [])
    {
        $this->validator = $validator;
        $this->message = $message;
        $this->args = $args;
    }


    public function getField()
    {
        return $this->field;
    }

    public function setField($field)
    {
        $this->field = $field;
    }

    public function getValidator()
    {
        return $this->validator;
    }

    public function setValidator($validator)
    {
        $this->validator = $validator;
    }

    public function getArgs()
    {
        return $this->args;
    }

    public function setArgs($args)
    {
        $this->args = $args;
    }

    public function getMessage()
    {
        return $this->message;
    }

    public function setMessage($message)
    {
        $this->message = $message;
    }

    public function validate($field)
    {
        $function = $this->validator;
        return $function($field, $this->args);
    }
}
