<?php

namespace IZON\Forms\Fields;

/**
 * Pole odpovidajici input text
 */
class TextField extends BaseField
{
    /**
     * @var int maximalni delka textu
     */
    protected int $maxLength = -1;

    public function __construct(string $name, string $label = '')
    {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
    }

    public function parse()
    {
        if (
            $this->nullOnEmpty
            && (
                $this->value === null
                || empty(trim($this->value))
            )
        ) {
            return null;
        } else {
            return (string)$this->value;
        }
    }

    public function getMaxLength(): int
    {
        return $this->maxLength;
    }

    /**
     *
     * @param int $maxLength maximalni delka textu
     * @return TextField
     */
    public function setMaxLength(int $maxLength): TextField
    {
        $this->maxLength = $maxLength;
        if ($maxLength > 0) {
            $this->attributes["maxlength"] = $maxLength;
        } else {
            unset($this->attributes["maxlength"]);
        }
        return $this;
    }

    public function serialize($value)
    {
        $this->value = $value;
    }

    public function validate(): void
    {
        if ($this->required) {
            if (!preg_match("#[[:graph:]]+#u", $this->value)) {
                $this->errors[] = _("Pole je povinné");
            }
        }
        foreach ($this->rules as $rule) {
            if (!$rule->validate($this)) {
                $this->errors[] = sprintf($rule->getMessage(), $rule->getArgs());
            }
        }
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
