<?php

namespace IZON\Forms\Fields;

/**
 * Pole odpovidajici input text
 */
class IdField extends BaseField
{
    /**
     *
     * @param string $name
     * @param string $label
     */
    public function __construct(string $name, string $label = '')
    {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
        $this->nullOnEmpty = true;
    }

    public function parse()
    {
        if (
            $this->nullOnEmpty
            && empty(trim((string)$this->value))
        ) {
            return null;
        } else {
            return $this->value;
        }
    }

    public function serialize($value)
    {
        $this->value = $value;
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
