<?php


namespace IZON\Forms\Fields;

use Exception;
use IZON\DB\EntityManagerInterface;

class EntityHiddenField extends BaseField
{
    /**
     * @var EntityManagerInterface
     */
    protected $entityManager;

    /**
     * @var string
     */
    protected $entityClass;

    /**
     * EntityField constructor.
     */
    public function __construct(string $fieldName, EntityManagerInterface $entityManager, string $entityClass)
    {
        $this->name = $fieldName;
        $this->propertyName = $this->name;
        $this->entityManager = $entityManager;
        $this->entityClass = $entityClass;
    }

    public function parse()
    {
        if (empty($this->getValue())) {
            return null;
        }
        return $this->entityManager->find($this->entityClass, json_decode(base64_decode($this->getValue()), true));
    }

    public function serialize($value)
    {
        if (!empty($value) && !is_a($value, $this->entityClass)) {
            throw new Exception("Field {$this->getFormName()} serializes class {$this->entityClass}. " . get_class($value) . " provided.");
        }
        $this->setValue(self::serializeEntity($this->entityManager, $value));
    }

    /**
     * serializes Doctrine entity to fomat accepted by this field
     * @param EntityManagerInterface $entityManager
     * @param object|null $object
     * @return string
     */
    public static function serializeEntity(EntityManagerInterface $entityManager, $object): string
    {
        if ($object === null) {
            return '';
        }
        $meta = $entityManager->getClassMetadata(get_class($object));
        $identifier = $meta->getIdentifierValues($object);
        return base64_encode(json_encode($identifier));
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
