<?php

namespace IZON\Forms\Fields;

use IZON\Forms\ValidationRule;
use IZON\Utils\Email;

/**
 * Emailove pole
 */
class EmailField extends CharField
{
    public function __construct(string $name, string $label = '')
    {
        parent::__construct($name, $label);

        $function = function (BaseField $field, $args = []) {
            // prazdne pole se neestuje
            if ($field->parse() == '') {
                return true;
            }
            return Email::isEmail($field->parse());
        };
        $rule = new ValidationRule($function, _('Zadaná emailová adresa není platná.'));
        $this->addRule($rule);
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
