<?php

namespace IZON\Forms\Fields;

use Exception;
use IZON\Forms\ValidationRule;
use IZON\Utils\Date;

/**
 * Pole odpovidajici input text
 */
class DateTimeFiled extends BaseField
{
    protected string $dateFormat = "j.n.Y G:i";

    /**
     *
     * @param string $name
     * @param string $label
     */
    public function __construct(string $name, string $label = '')
    {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;

        $rule = new ValidationRule();
        $rule->setMessage(_('Zadaná hodnota není platné datum a čas.'));

        $function = function (DateTimeFiled $field, $args = []) {
            // neni pozadovano a je prazdne
            if (!$field->isRequired() && empty($this->getValue())) {
                return true;
            } else {
                $date = Date::createFromFormat($field->getDateFormat(), $field->getValue());
                return $date != false;
            }
        };
        $rule->setValidator($function);
        $this->addRule($rule);
    }

    public function getDateFormat(): string
    {
        return $this->dateFormat;
    }

    /**
     * @param string $dateFormat
     * @return static
     */
    public function setDateFormat(string $dateFormat): DateTimeFiled
    {
        // TODO: kontrola ze je korektni format data
        $this->dateFormat = $dateFormat;
        return $this;
    }

    public function parse()
    {
        if (!$this->required
            && $this->value == "") { // je povoleno prazdne pole a pole je prazdne
            return null;
        } else {
            $date = Date::createFromFormat($this->dateFormat, $this->value);
            return $date;
        }
    }

    public function serialize($value)
    {
        if ($value instanceof Date) { // parametr je objekt date
            $val = $value->format($this->dateFormat);
            $this->value = $val;
        } elseif ($value == null) { // me mozne nezadat datum a predava se null jako hodnota
            $this->value = '';
        } else {
            throw new Exception('Parameter $value of Filed ' . $this->getName() . ' isn\'t of type Date or empty');
        }
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
