<?php

namespace IZON\Forms\Fields;

use Exception;
use IZON\Forms\ValidationRule;
use IZON\Utils\Date;

/**
 * Pole, ktere zobrazuje pouze datum
 */
class DateFiled extends BaseField
{
    protected string $dateFormat = "Y-m-d";

    /**
     * @param string $name
     * @param string $label
     */
    public function __construct(string $name, string $label = '')
    {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;

        $rule = new ValidationRule();
        $rule->setMessage(_('Zadaná hodnota není platné datum.'));

        $function = function (DateFiled $field, $args = []) {
            // neni pozadovano a je prazdne
            if (!$field->isRequired() && $this->getValue() == "") {
                return true;
            } else {
                $date = Date::createFromFormat($field->getDateFormat(), $field->getValue());
                return $date != false;
            }
        };
        $rule->setValidator($function);
        $this->addRule($rule);
    }

    public function getDateFormat(): string
    {
        return $this->dateFormat;
    }

    /**
     *
     * @param string $dateFormat
     * @return static
     */
    public function setDateFormat(string $dateFormat): DateFiled
    {
        // TODO: kontrola ze je korektni format data
        $this->dateFormat = $dateFormat;
        return $this;
    }

    public function parse()
    {
        if (
            !$this->required
            && $this->value == ""
        ) {
            return null;
        } elseif (
            $this->nullOnEmpty &&
            empty(trim($this->value))
        ) {
            return null;
        } else {
            $date = Date::createFromFormat($this->dateFormat, $this->value);
            return $date;
        }
    }

    public function serialize($value)
    {
        if ($value instanceof Date) { // parametr je objekt date
            $val = $value->format($this->dateFormat);
            $this->value = $val;
        } elseif ($value == null) { // me mozne nezadat datum a predava se null jako hodnota
            $this->value = '';
        } else {
            throw new Exception(
                'Parameter $value of Filed ' . $this->getName() . ' isn\'t of type Date or allows to be NULL'
            );
        }
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
