<?php

namespace IZON\Forms\Fields;

/**
 * Chechbox that returns values true and false
 *
 * inspiruje se z http://doc.nette.org/cs/2.3/forms#toc-addcheckbox
 */
class CheckboxField extends BaseField
{
    public function __construct(string $name, string $label = '')
    {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
    }

    public function parse()
    {
        return boolval($this->value);
    }

    public function serialize($value)
    {
        $this->value = boolval($value);
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
