<?php

namespace IZON\Forms\Fields;

/**
 * Pole odpovidajici input text
 */
class CharField extends BaseField
{
    /**
     * @var int maximalni delka textu
     */
    protected int $maxLength = -1;

    public function __construct(string $name, string $label = '')
    {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
    }

    public function parse()
    {
        if (
            $this->nullOnEmpty
            && (
                $this->value == null
                || empty(trim($this->value))
            )
        ) {
            return null;
        } else {
            return (string)$this->value;
        }
    }

    public function serialize($value)
    {
        $this->value = $value;
    }

    public function getMaxLength()
    {
        return $this->maxLength;
    }

    /**
     *
     * @param integer $maxLength maximalni delka textu
     * @return CharField
     */
    public function setMaxLength(int $maxLength): CharField
    {
        $this->maxLength = $maxLength;
        if ($maxLength > 0) {
            $this->attributes["maxlength"] = $maxLength;
        } else {
            unset($this->attributes["maxlength"]);
        }
        return $this;
    }

    public function validate(): void
    {
        if (
            $this->required // je povinne
            && !$this->nullOnEmpty
        ) { // a neni povoleno zadat prazdne pole, aby se vratil null
            if (!preg_match("#[[:graph:]]+#u", $this->value ?? '')) {
                $this->errors[] = _("Pole je povinné");
            }
        }
        $currentLength = $this->value === null ? 0 : mb_strlen($this->value);
        if ($this->maxLength > 0 // je nastavena delka
            && $currentLength > $this->maxLength) {
            $this->errors[] = _("Maximální délka je ") . $this->maxLength;
        }
        foreach ($this->rules as $rule) {
            if (!$rule->validate($this)) {
                $this->errors[] = sprintf($rule->getMessage(), $rule->getArgs());
            }
        }
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
