<?php

namespace IZON\Forms;

/**
 * defines interface for Form/FormSet with common methods
 * for editing and validation
 */
interface FormInterface
{
    /**
     * pri edit/flush hodont do/z formulare pristupovat primo na property
     */
    public const EDIT_FLUSH_ACCESS_PROPERTIES = 1;

    /**
     * pri edit/flush hodont do/z formulare pristupovat pres gettery a settery
     */
    public const EDIT_FLUSH_ACCESS_GETTERS_SETTERS = 2;

    /**
     * inicializes values of Fields from array
     * @param array<string, mixed> $array
     */
    public function setValues(array $array);

    /**
     * returns array with same structura as array used to initialize FormInterface in setValues
     * @return array<string, mixed>
     */
    public function getValues(): array;

    /**
     * @return string[] reprezentuje preffix
     */
    public function getPrefix(): array;

    /**
     *
     * @param string[] $prefix
     */
    public function setPrefix(array $prefix);

    /**
     * performs validation of the Form (executes all field validation rules and form validator)
     * of FormSet (executes validate for all FormInterface in FormSet and form validator)
     */
    public function validate(): void;

    /**
     * zjisti jestli ma formular nebo nejake formularove pole chybu
     * @return bool
     */
    public function hasErrors(): bool;

    /**
     * ze zadaneho objektu nastavi hodnoty jednotlivych formularovych poli
     * @param mixed $object z jakeho objektu se maji ziskat data
     */
    public function edit($object): void;

    /**
     * z hodnot formularovych poli nastavi hodnoty poli v objektu
     */
    public function flush($object): void;
}
