<?php

namespace IZON\Forms\Fields;

/**
 * Radio
 *
 * inspiruje se z http://doc.nette.org/cs/2.3/forms#toc-addselect
 */
class RadioListField extends BaseField
{
    /**
     * pouziva se pokud jsou $options objekty nebo pole
     *
     * funkce, ktera z objektu vytahne hodnotu pouzivanou ve formulari jako value
     * @var null|callable
     */
    protected $valueExtractor = null;

    /**
     * moznosti zobrazene v radiolistu
     * asociativni pole, kde key je navratova  hodnota a value je hodnota co se ma zobrazovat
     * @var array
     */
    protected array $options = [];

    protected $descriptionExtractor = null;

    public function __construct($name, $label = '')
    {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
    }

    /**
     * pouziva se pokud jsou $options objekty nebo pole
     *
     * funkce, ktera z objektu vytahne hodnotu pouzivanou ve formulari popis polozky
     * @return mixed
     */
    public function parse()
    {
        if (
            $this->nullOnEmpty
            && empty(trim($this->value))
        ) {
            return null;
        } else {
            return $this->value;
        }
    }

    public function getOptions(): array
    {
        return $this->options;
    }

    public function setOptions(array $options)
    {
        $this->options = $options;
        return $this;
    }

    public function serialize($value)
    {
        $this->value = $value;
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
