<?php

namespace IZON\Forms\Fields;

use IZON\Forms\ValidationRule;

/**
 * Pole pro telefoni cislo
 */
class PhoneField extends CharField
{
    // TODO: replace with regex array with possible formats

    /**
     * @var string regex for number with international prefix
     */
    protected string $numberWithCountryCodeRegex = "/^(\+|00)[1-9][0-9]{0,4}[0-9]{9,15}$/";

    /**
     * @var string regex for number without international prefix
     */
    protected string $numberWithoutCountryCodeRegex = "/^[0-9]{9,15}$/";


    public function __construct(string $name, string $label = '')
    {
        parent::__construct($name, $label);

        $rule = new ValidationRule(
            function (BaseField $field, $args = []) {
                if ($field->parse() == '') {
                    return true;
                }

                $numberWithCountryCodeRegex = $this->numberWithCountryCodeRegex;
                $numberWithoutCountryCodeRegex = $this->numberWithoutCountryCodeRegex;

                $value = preg_replace('/\s+/', '', $field->parse());
                return preg_match($numberWithCountryCodeRegex, $value) // phone number with country code
                    || preg_match($numberWithoutCountryCodeRegex, $value); // phone number without country code
            },
            _('Zadané telefoní číslo není platné.')
        );
        $this->addRule($rule);
    }

    public function removeAllRules(): void
    {
        $this->rules = [];
    }

    public function setNumberWithCountryCodeRegex(string $numberWithCountryCodeRegex): void
    {
        $this->numberWithCountryCodeRegex = $numberWithCountryCodeRegex;
    }

    public function setNumberWithoutCountryCodeRegex(string $numberWithoutCountryCodeRegex): void
    {
        $this->numberWithoutCountryCodeRegex = $numberWithoutCountryCodeRegex;
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
