<?php

namespace IZON\Forms\Fields;

/**
 * Pole odpovidajici input text
 */
class PasswordField extends BaseField
{
    /**
     * @param string $name
     * @param string $label
     */
    public function __construct(string $name, string $label = '')
    {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
    }

    public function parse()
    {
        return (string)$this->value;
    }

    public function serialize($value)
    {
        $this->value = $value;
    }

    /**
     * Nezobrazovat heslo ve formulari
     */
    public function getValue()
    {
        //        throw new \Exception("not implemented PasswordField");
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
