<?php

namespace IZON\Forms\Fields;

use IZON\Forms\ValidationRule;
use IZON\Utils\Email;

/**
 * Emailove pole
 */
class MultipleEmailField extends CharField
{
    public function __construct(string $name, string $label = '')
    {
        parent::__construct($name, $label);

        $function = function (BaseField $field, $args = []) {
            // do not validate enpty field
            if (empty($field->parse())) {
                return true;
            }
            $parsed = $field->parse();
            $emails = preg_split('/\s*,\s*/', $parsed);
            $i = 1;
            foreach ($emails as $email) {
                if (empty($email)) {
                    $field->addError(sprintf(_('Není vyplněný %s. email.'), $i));
                }
                if (!Email::isEmail($email)) {
                    $field->addError(sprintf(_('Email %s. není validní.'), $i));
                }
                $i++;
            }
            return !$field->hasErrors();
        };
        $rule = new ValidationRule($function, _('Zadané emaily nejsou platné.'));
        $this->addRule($rule);
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
