<?php

namespace IZON\Forms\Fields;

use InvalidArgumentException;

/**
 * Pole odpovidajici input text
 */
class IntegerField extends BaseField
{
    /**
     * @var null|int minimalni hodnota, ktera muze byt do pole zadana
     */
    protected ?int $minValue = null;

    /**
     * @var null|int maximalni hodnota, ktera muze byt do pole zadana
     */
    protected ?int $maxValue = null;

    /**
     * @var int
     */
    protected int $step = 1;

    /**
     *
     * @param string $name
     * @param string $label
     */
    public function __construct(string $name, $label = '')
    {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
    }

    public function parse()
    {
        if ($this->nullOnEmpty
            && empty(trim($this->value))) {
            return null;
        } else {
            return intval($this->value);
        }
    }

    public function serialize($value)
    {
        if (is_null($value) || (is_string($value) && $value == '')) {
            $this->value = '';
            return;
        }
        $this->value = $value == 0 ? '0' : $value;
    }

    public function getMinValue(): ?int
    {
        return $this->minValue;
    }

    /**
     * minimalni hodota, ktera muze byt do pole zadana
     * @param null|int $minValue null to set no minimum
     * @return IntegerField
     */
    public function setMinValue(?int $minValue): IntegerField
    {
        $this->minValue = $minValue;
        return $this;
    }

    public function getMaxValue(): ?int
    {
        return $this->maxValue;
    }

    /**
     * maximalni hodota, ktera muze byt do pole zadana
     * @param null|int $maxValue null to set no maximum
     * @return IntegerField
     */
    public function setMaxValue(?int $maxValue): IntegerField
    {
        $this->maxValue = $maxValue;
        return $this;
    }

    public function getStep(): int
    {
        return $this->step;
    }

    public function setStep(int $step): IntegerField
    {
        if ($step <= 0) {
            throw new InvalidArgumentException("Step must be greater than 0.");
        }
        $this->step = $step;
        return $this;
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
