<?php

namespace IZON\Forms\Fields;

use IZON\IO\File;

/**
 * Field to upload file
 * @deprecated consider other way to upload files
 */
class FileField extends BaseField
{
    public function __construct(string $name, string $label = '')
    {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
    }

    public function parse()
    {
        // neposlal se soubor
        if (!file_exists($_FILES[$this->name]["tmp_name"])) {
            return null;
        }

        //        var_dump($_FILES);
        //        var_dump($_FILES[$this->name]);
        // kde je soubor ulozen
        $fileURI = $_FILES[$this->name]["tmp_name"];
        // ciste jmeno
        $fileName = File::getSafeFileName($_FILES[$this->name]["name"]);

        session_start();
        // presun do temporary souboru
        // TODO: udelat nejak inteligentneji, aby se dano nastavovat
        $tempFileDir = __BASE_DIR__ // @phpstan-ignore-line
            . "/tmp/user-data/" . session_id() . "/files";
        if (!file_exists($tempFileDir)) {
            // vytvor temporry
            mkdir($tempFileDir, 0700, true);
        }
        $tempFileName = $tempFileDir . "/" . $fileName;
        move_uploaded_file($fileURI, $tempFileName);

        //        var_dump($tempFileName);
        //        move_uploaded_file($filename, $destination);
        if ($fileName == null) {
            return null;
        } else {
            return new File($tempFileName);
        }
    }

    /**
     *
     * @param File $value
     */
    public function serialize($value)
    {
        if ($value == null) {
            $this->value = null;
        } else {
            $this->value = $value->getRealPath();
        }
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
