<?php

namespace IZON\Forms\Fields;

use IZON\Forms\Fields\BaseField;
use IZON\Forms\ValidationRule;

/**
 * Pole pro telefoni cislo
 */
class PhoneField extends CharField
{

    public function __construct($name, $label = '', $params = array())
    {
        parent::__construct($name, $label, $params);

        $errorMessages = _('Zadané telefoní číslo není platné.');

        $rule = new ValidationRule();
        $rule->setField($this);
        $rule->setMessage($errorMessages);

        $function = function (BaseField $field, $args = array()) {
            if ($field->parse() == '') {
                return true;
            }

            $value = preg_replace('/\s+/', '', $field->parse());
            return preg_match("/^\+[0-9]{2,5}[0-9]{9,15}$|^[0-9]{9,15}$/", $value);
        };
        $rule->setValidator($function);

        $this->rules[] = $rule;
        $this->addAttribute('data-error-message', $errorMessages);

        return $this;
    }

    public function removeAllRules()
    {
        $this->rules = [];
    }

    protected function getSpecificSupportedProperties(): array
    {
        return [];
    }
}
