<?php

namespace IZON\Forms;


/**
 * defines interface for Form/FormSet with common methods
 * for editing and validation 
 */
interface FormInterface {

    /**
     * inicializes values of Fields from array 
     * @param array $array
     */
    public function setValues(array $array);
    
    /**
     * returns array with same structura as array used to initialize FormInterface in setValues
     * @return array
     */
    public function getValues(): array;

    /**
     * @return array reprezentuje preffix
     */
    public function getPrefix();
    
    /**
     * 
     * @param array $prefix
     */
    public function setPrefix(array $prefix);
    
    /**
     * provede validaci formulare jako celku
     * @return boolean
     */
    public function validate();
    
    /**
     * zjisti jestli ma formular nebo nejake formularove pole chybu
     * @return boolean
     */
    public function hasErrors();
    
//    public function hasFormErrors();
//    
//    /**
//     * prida chybu navazanou primo na formulari ne navazane na formularove pole
//     * @param string $errorMessage
//     */
//    function addFormError($errorMessage);
//    
//    /**
//     * vrati chyby navazane primo na formulari ne navazane na formularove pole
//     * @return array
//     */
//    function getFormErrors();

    /**
     * ze zadaneho objektu nastavi hodnoty jednotlivych formularovych poli
     * @param mixed $object z jakeho objektu se maji ziskat data
     */
    public function edit($object);

    /**
     * z hodnot formularovych poli nastavi hodnoty poli v objektu
     */
    public function flush($object);
}
