<?php

namespace IZON\Forms\Fields;

use Exception;

use \IZON\Utils\Date;

use \IZON\Forms\ValidationRule;

/**
 * Pole, ktere zobrazuje pouze datum
 */
class DateFiled extends BaseField {
    
    protected $dateFormat = "Y-m-d";

    /**
     * @param string $name
     * @param string $label
     * @param array $params ??? pouzivat
     * @return PasswordField
     */
    public function __construct($name, $label = '', $params = array()) {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
        $this->errors = array();
        
        // moznost zmenit dateFormat
        if( isset($params["dateFormat"]) ) {
            $this->dateFormat = $params["dateFormat"];
        }
        
        $rule = new ValidationRule();
        $rule->setMessage(_('Zadaná hodnota není platné datum.'));

        $function = function(DateFiled $field, $args = array()) {
            // neni pozadovano a je prazdne
            if( !$field->getRequired() && $this->getValue() == "" ) {
                return true;
            } else {
                $date = Date::createFromFormat($field->getDateFormat(), $field->getValue());
                return $date != false;
            }
        };
        $rule->setValidator($function);
        $this->addRule($rule);
        
        return $this;
    }
    
    public function parse() {
        if( !$this->required 
            && $this->value == "" ) { // je povoleno prazdne pole a pole je prazdne
            return NULL;
        } else {
            if ($this->nullOnEmpty && 
                empty(trim($this->value))) {
                return null;
            } else {
                $date = Date::createFromFormat($this->dateFormat, $this->value);
                return $date;
            }
        }
    }

    public function serialize($value) {
        if( $value instanceof Date ) { // parametr je objekt date
            $val = $value->format($this->dateFormat);
            $this->value = $val;
        } else if( $value == NULL ) { // me mozne nezadat datum a predava se null jako hodnota
            $this->value = '';
        } else {
            throw new Exception('Parameter $value of Filed '. $this->getName() .' isn\'t of type Date or allows to be NULL');
        }
    }
    
    function getDateFormat() {
        return $this->dateFormat;
    }

    /**
     * 
     * @param string $dateFormat
     */
    function setDateFormat($dateFormat) {
        // TODO: kontrola ze je korektni format data
        $this->dateFormat = $dateFormat;
        return $this;
    }
    
    protected function getSpecificSupportedProperties(): array {
        return [];
    }
}
