<?php

namespace IZON\Forms\Fields;

use IZON\IO\Image;
use IZON\IO\File;

/**
 * Field to upload file
 */
class ImageField extends BaseField {

    public function __construct($name, $label = '', $params = array()) {
        $this->name         = $name;
        $this->label        = $label;
        $this->propertyName = $this->name;
        $this->errors       = array();
        return $this;
    }

    public function parse() {
        if( !file_exists($_FILES[$this->name]["tmp_name"]) ) {
            return NULL;
        }

        // kde je soubor ulozen
        $fileURI = $_FILES[$this->name]["tmp_name"];
        // ciste jmeno
        $fileName = File::getSafeFileName($_FILES[$this->name]["name"]);
        // presun do temporary souboru
        // TODO: udelat nejak inteligentneji, aby se dano nastavovat
        $tempFileDir = __BASE_DIR__ ."/app-data/tmp/user-sessions-data/". session_id() ."/files";
        if( !file_exists($tempFileDir) ) {
            // vytvor temporry
            mkdir($tempFileDir, 0700, true);
        }
        $tempFileName = $tempFileDir ."/". $fileName;
        move_uploaded_file($fileURI, $tempFileName);

//        var_dump($tempFileName);
//        move_uploaded_file($filename, $destination);
        if($fileName == NULL) {
            return NULL;
        } else {
            return new Image($tempFileName);
        }
    }

    /**
     *
     * @param Image $value
     */
    public function serialize($value) {
        if($value == NULL) {
            $this->value = NULL;
        } else {
            $this->value = $value->getWebURI();
        }
    }

    protected function getSpecificSupportedProperties(): array {
        return [];
    }
}
