<?php

namespace IZON\Forms\Fields;

use IZON\Utils\Email;

use IZON\Forms\Fields\BaseField;
use IZON\Forms\ValidationRule;

/**
 * Emailove pole
 */
class EmailField extends CharField {

    public function __construct($name, $label = '', $params = array()) {
        $ret = parent::__construct($name, $label, $params);

        $function = function(BaseField $field, $args = array()) {
            // prazdne pole se neestuje
            if( $field->parse() == '' ) {
                return true;
            }
            return Email::isEmail($field->parse());
        };
        $rule = new ValidationRule($function, _('Zadaná emailová adresa není platná.'));
        $this->addRule($rule);

        return $this;
    }

    protected function getSpecificSupportedProperties(): array {
        return [];
    }
}