<?php

namespace IZON\Forms;

/**
 * Description of FormError
 *
 * @author ludwig
 */
class FormError {
    
    /**
     * Nekriticka chyba
     */
    const LEVEL_WARNING = 'WARNING';
    
    /**
     * Kriticka chyba
     */
    const LEVEL_ERROR = 'ERROR';
    
    /**
     *
     * @var string
     */
    protected $code;
    
    /**
     *
     * @var string
     */
    protected $title;
    
    /**
     *
     * @var string
     */
    protected $message;
    
    /**
     * mozne hodnoty: <br>warning - nekriticka chyba<br>error - kriticka chyba
     * 
     * @var string [warning|error]
     */
    protected $level;


    public function getCode() {
        return $this->code;
    }

    public function getTitle() {
        return $this->title;
    }

    public function getMessage() {
        return $this->message;
    }

    public function setCode($code) {
        $this->code = $code;
    }

    public function setTitle($title) {
        $this->title = $title;
    }

    public function setMessage($message) {
        $this->message = $message;
    }

    public function getLevel() {
        return $this->level;
    }

    /**
     * mozne hodnoty: <br>warning - nekriticka chyba<br>error - kriticka chyba
     * 
     * @var string [warning|error]
     */
    public function setLevel($level) {
        $this->level = $level;
    }

    public function toString($separator = '<br>', $code = false) {
        return ($code ? $this->code . $separator : '') . $this->title . $separator . $this->message;
    }

    public function toArray() {
        return ['code' => $this->code, 'title' => $this->title, 'message' => $this->message];
    }

    /**
     * Je level zpravy "WARNING", tzn. vyskytla se nejaka chyba, ale nejedna se o kririckou chybu
     * 
     * @return bool
     */
    public function isWarning() {
        return $this->level == self::LEVEL_WARNING;
    }

    /**
     * Je level zpravy "ERROR", tzn. vyskytla se kriticka chyba
     * 
     * @return bool
     */
    public function isError() {
        return $this->level == self::LEVEL_ERROR;
    }

}
