<?php

namespace IZON\Forms;

use IZON\Forms\Fields\BaseField;

/**
 * Validacni pravidlo
 */
class ValidationRule {
    
    /**
     * 
     * @var BaseField ke kteremu poli se validacni pravidlo vaze
     */
    public $field;

    /**
     * @var callable funkce provadejici validaci
     */
    public $validator;

    /** 
     * @var string 
     */
    public $message;
    
    /**
     * argumenty potrebne pro validaci pravidla
     * @var array 
     */
    public $args;
    
    
    function __construct(callable $validator = null, $message = null, $args = []) {
        $this->validator = $validator;
        $this->message = $message;
        $this->args = $args;
    }
    
    
    function getField() {
      return $this->field;
    }

    function getValidator() {
      return $this->validator;
    }

    function getArgs() {
      return $this->args;
    }

    function getMessage() {
      return $this->message;
    }

    function setField($field) {
      $this->field = $field;
    }

    function setValidator($validator) {
      $this->validator = $validator;
    }

    function setArgs($args) {
      $this->args = $args;
    }

    function setMessage($message) {
      $this->message = $message;
    }
    
    public function validate($field) {
        $function = $this->validator;
        return $function($field, $this->args);
    }


}
