<?php

namespace IZON\Forms\Fields;

/**
 * Pole odpovidajici input text
 */
class FloatField extends BaseField {
    
    protected $step = 0.00000001;
    
    /**
     * @var float minimalni hodnota, ktera muze byt do pole zadana
     */
    protected $minValue = FALSE;
    
    /**
     * @var float maximalni hodnota, ktera muze byt do pole zadana
     */
    protected $maxValue = FALSE;

    /**
     * 
     * @param string $name
     * @param string $label
     * @param array $params
     * @return self
     */
    public function __construct($name, $label = '', $params = []) {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
        $this->errors = array();
        return $this;
    }

    public function parse() {
        if( $this->nullOnEmpty && empty(trim($this->value)) ) {
            return null;
        } else {
            return floatval($this->value);
        }
        return floatval($this->value);
    }

    public function serialize($value) {
        if(is_null($value) || (is_string($value) && $value == '')) {
            $this->value = '';
            return;
        }
        $reminder = fmod($value, $this->step);
        if($reminder > $this->step / 2) {
            $reminder -= $this->step;
        }
        $value -= $reminder;
        $this->value = str_replace(",", ".", $value);
    }

    function getStep() {
        return $this->step;
    }

    function setStep($step) {
        if($step <= 0) {
            throw new Exception("Step nesmi byt nulovy nebo zaporny");
        }
        $this->step = $step;
        return $this;
    }

    function getMinValue() {
        return $this->minValue;
    }

    function getMaxValue() {
        return $this->maxValue;
    }

    /**
     * minimalni hodota, ktera muze byt do pole zadana
     * @param float $minValue
     * @return FloatField
     */
    function setMinValue($minValue) {
        $this->minValue = $minValue;
        return $this;
    }

    /**
     * maximalni hodota, ktera muze byt do pole zadana
     * @param float $maxValue
     * @return FloatField
     */
    function setMaxValue($maxValue) {
        $this->maxValue = $maxValue;
        return $this;
    }

    protected function getSpecificSupportedProperties(): array {
        return [];
    }
}
