<?php


namespace IZON\Forms\Fields;


use IZON\DB\EntityManagerInterface;

class EntityHiddenField extends BaseField {
    /**
     * @var EntityManagerInterface
     */
    protected $entityManager;

    /**
     * @var string
     */
    protected $entityClass;

    /**
     * EntityField constructor.
     */
    public function __construct(string $fieldName, EntityManagerInterface $entityManager, string $entityClass) {
        $this->name = $fieldName;
        $this->propertyName = $this->name;
        $this->entityManager = $entityManager;
        $this->entityClass = $entityClass;
    }

    function parse() {
        if(empty($this->getValue())) {
           return null;
        }
        return $this->entityManager->find($this->entityClass, json_decode(base64_decode($this->getValue()), true));
    }

    function serialize($value) {
        if(empty($value)) {
           $this->value = null;
        }
        if(!is_a($value, $this->entityClass)) {
            throw new \Exception("Serializing not {$this->entityClass} in field {$this->getFormName()}");
        }
        $meta = $this->entityManager->getClassMetadata(get_class($value));
        $identifier = $meta->getIdentifierValues($value);
        $this->setValue(base64_encode(json_encode($identifier)));
    }

    protected function getSpecificSupportedProperties(): array {
        return [];
    }

}
