<?php

namespace IZON\Forms\Fields;

use IZON\Forms\Fields\CharField;

/**
 * Pole odpovidajici input text
 */
class TextField extends BaseField {

    /**
     * 
     * @param string $name
     * @param string $label
     * @param array $params
     * @return CharField
     */
    public function __construct($name, $label = '', $params = array()) {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
        $this->errors = array();
        return $this;
    }

    public function parse() {
        if($this->nullOnEmpty &&
                empty(trim($this->value))) {
            return null;
        } else {
            return (string) $this->value;
        }
    }

    public function serialize($value) {
        $this->value = $value;
    }

    public function validate() {
        if($this->required) {
            if(!preg_match("#[[:graph:]]+#u", $this->value)) {
                $this->errors[] = _("Pole je povinné");
            }
        }
        foreach($this->rules as $rule) {
            if(!$rule->validate($this)) {
                $this->errors[] = sprintf($rule->getMessage(), $rule->getArgs());
            }
        }
        return $this->errors;
    }
  protected function getSpecificSupportedProperties(): array {
        return [];
    }

}
