<?php

namespace IZON\Forms\Fields;

use IZON\Forms\Fields\BaseField;
use IZON\Forms\ValidationRule;

/**
 * Pole pro telefoni cislo
 */
class PhoneField extends CharField {

    public function __construct($name, $label = '', $params = array()) {
        $ret = parent::__construct($name, $label, $params);

        $rule = new ValidationRule();
        $rule->setField($this);
        $rule->setMessage(_('Zadané telefoní číslo není platné.'));

        $function = function(BaseField $field, $args = array()) {
            if($field->parse() == '') {
                return true;
            }

            $value = preg_replace('/\s+/', '', $field->parse());
            return preg_match("/^\+[0-9]{2,5}[1-9][0-9]{8,14}$|^[1-9][0-9]{8,14}$/", $value);
        };
        $rule->setValidator($function);

        $this->rules[] = $rule;

        return $this;
    }

    public function removeAllRules() {
        $this->rules = [];
    }
}
