<?php

namespace IZON\Forms\Fields;

/**
 * Pole odpovidajici input text
 */
class IntegerField extends BaseField {
    
    /**
     * @var integer minimalni hodnota, ktera muze byt do pole zadana
     */
    protected $minValue = FALSE;
    
    /**
     * @var integer maximalni hodnota, ktera muze byt do pole zadana
     */
    protected $maxValue = FALSE;
    
    /**
     * @var integer
     */
    protected $step = 1;

    /**
     * 
     * @param string $name
     * @param string $label
     * @param array $params
     * @return PasswordField
     */
    public function __construct($name, $label = '', $params = array()) {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
        $this->errors = array();
        return $this;
    }
    
    public function parse() {
        if ($this->nullOnEmpty && 
            empty(trim($this->value))) {
            return null;
        } else {
            return intval($this->value);
        }
    }

    public function serialize($value) {
        $this->value = $value;
    }
    
    function getMinValue() {
        return $this->minValue;
    }

    function getMaxValue() {
        return $this->maxValue;
    }

    /**
     * minimalni hodota, ktera muze byt do pole zadana
     * @param float $minValue
     * @return FloatField
     */
    function setMinValue($minValue) {
        $this->minValue = $minValue;
        return $this;
    }

    /**
     * maximalni hodota, ktera muze byt do pole zadana
     * @param float $minValue
     * @return FloatField
     */
    function setMaxValue($maxValue) {
        $this->maxValue = $maxValue;
        return $this;
    }
    public function getStep() {
      return $this->step;
    }

    public function setStep($step) {
        // TODO: prdat kontrolu na to jestli je korektni
//        if( $step <= 0) {
//            throw new Exception("Step nesmi byt 1 nebo mensi");
//        }
        $this->step = (int)$step + 0 > 0 ? $step : 1;
        return $this;
    }
}
