<?php

namespace IZON\Forms\Fields;

/**
 * Combobox
 * 
 * inspiruje se z http://doc.nette.org/cs/2.3/forms#toc-addselect
 */
class SelectField extends BaseField {
    
    /**
     * text pro nevyplneno
     * @var string 
     */
    protected $unselectedText = NULL;
    
    /**
     * moznosti zobrazene v comboboxu
     * asociativni pole, kde key je navratova  hodnota a value je hodnota co se ma zobrazovat
     * @var array 
     */
    protected $options = [];
    
    public function __construct($name, $label = '', $params = array()) {
        $this->name         = $name;
        $this->label        = $label;
        $this->propertyName = $this->name;
        $this->errors       = array();
        return $this;
    }
    
    
    public function parse() {
        if ($this->nullOnEmpty && empty(trim($this->value))) {
            return null;
        } else {
            return $this->value;
        }
    }

    public function serialize($value) {
        $this->value = $value;
    }

    function getUnselectedText() {
        return $this->unselectedText;
    }

    function getOptions() {
        return $this->options;
    }

    /**
     * @param string $unselectedText
     * @return SelectField
     */
    function setUnselectedText($unselectedText) {
        $this->unselectedText = $unselectedText;
        return $this;
    }

    /**
     * 
     * @param array $options je bud jednoduche pole kde klice jsou value u prvku option a hodnoty jsou popisty option nebo pole poli kde vnorene pole je ve travu ["label" => "nazev tag group", "options" => [pole options jako v prvnim pripade]]
     * @return SelectField
     */
    function setOptions($options) {
        $this->options = $options;
        return $this;
    }
    
    public function __clone() {
        // naklonuje validacni pravidla
        $clonedRules = [];
        foreach($this->rules as $rule) {
            $clonedRule = clone $rule;
            $rule->setField($this);
            $clonedRules[] = $clonedRule;
        }
        $this->rules = $clonedRules;
    }
}
