<?php

namespace IZON\Forms\Fields;

/**
 * hidden pole
 */
class HiddenField extends BaseField {
    
    /**
     * 
     * @param string $name
     * @param string $label
     * @param array $params
     * @return PasswordField
     */
    public function __construct($name, $label = '', $params = array()) {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
        $this->errors = array();
        return $this;
    }
    
    public function parse() {
        if ($this->nullOnEmpty && 
            empty(trim($this->value))) {
            return null;
        } else {
            return $this->value;
        }
    }

    public function serialize($value) {
        $this->value = $value;
    }
}
