<?php

namespace IZON\Forms\Fields;

use Exception;

/**
 * Pole odpovidajici input text
 */
class PasswordField extends BaseField {

    /**
     * 
     * @param string $name
     * @param string $label
     * @param array $params
     * @return PasswordField
     */
    public function __construct($name, $label = '', $params = array()) {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
        $this->errors = array();
        return $this;
    }

    public function parse() {
        return (string)$this->value;
    }

    public function serialize($value) {
        $this->value = $value;
    }

    /**
     * Nezobrazovat heslo ve formulari
     * @throws Exception
     */
    public function getValue() {
//        throw new \Exception("not implemented PasswordField");
    }

}
