<?php

namespace IZON\Forms\Fields;

/**
 * Pole odpovidajici input text
 */
class CharField extends BaseField {

    /**
     * @var integer maximalni delka textu
     */
    protected $maxLength = -1;

    /**
     * 
     * @param string $name
     * @param string $label
     * @param array $params
     * @return CharField
     */
    public function __construct($name, $label = '', $params = array()) {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
        $this->errors = [];
        return $this;
    }

    public function parse() {
        if ($this->nullOnEmpty &&
            empty(trim($this->value))) {
            return null;
        } else {
            return (string)$this->value;
        }
    }

    public function serialize($value) {
        $this->value = $value;
    }

    /**
     * 
     * @param integer $maxLength maximalni delka textu
     * @return CharField
     */
    public function setMaxLength($maxLength) {
        $this->maxLength = $maxLength;
        if($maxLength > 0 ) {
            $this->attributes["maxlength"] = $maxLength;
        } else {
            unset($this->attributes["maxlength"]);
        }
        return $this;
    }

    function getMaxLength() {
        return $this->maxLength;
    }

    public function validate() {
        // TODO: prevest na validation rule
        if($this->required // je povinne
            && !$this->nullOnEmpty ) { // a neni povoleno zadat prazdne pole, aby se vratil null
            if (!preg_match("#[[:graph:]]+#", $this->value))
                $this->errors[] = _("Pole je povinné");
        }
        if( $this->maxLength > 0 // je nastavena delka 
            && mb_strlen($this->value) > $this->maxLength ) {
            $this->errors[] = _("Maximální délka je ") . $this->maxLength;
        }
        foreach ($this->rules as $rule) {
            if (!$rule->validate($this)) {
                $this->errors[] = sprintf($rule->getMessage(), $rule->getArgs());
            }
        }
        return $this->errors;
    }
}
