<?php

namespace IZON\Forms\Fields;

use IZON\Forms\Fields\BaseField;
use IZON\Forms\ValidationRule;

/**
 * Pole pro telefoni cislo
 */
class PhoneField extends CharField {

    public function __construct($name, $label = '', $params = array()) {
        $ret = parent::__construct($name, $label, $params);

        $rule = new ValidationRule();
        $rule->setField($this);
        $rule->setMessage(_('Zadané telefoní číslo není platné.'));

        $function = function(BaseField $field, $args = array()) {
            // prazdne pole se neestuje
            if( $field->parse() == '' ) {
                return true;
            }
            return preg_match("/^(\+)?([0-9]{2,5})? ?[0-9]{3,4} ?[0-9]{3} ?[0-9]{3}$/", $field->parse());
        };
        $rule->setValidator($function);

        $this->rules[] = $rule;

        return $this;
    }

}
